/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;

public class PScrollablePanel
extends JPanel
implements Scrollable {
    public static final byte TRACKING_POLICY_NEVER = 0;
    public static final byte TRACKING_POLICY_IF_WILL_EXPAND = 1;
    public static final byte TRACKING_POLICY_ALWAYS = 2;
    private Dimension preferredScrollableViewportSize;
    private byte widthTrackingPolicy;
    private byte heightTrackingPolicy;

    public PScrollablePanel() {
        this.initPanel();
    }

    public PScrollablePanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
        this.initPanel();
    }

    public PScrollablePanel(LayoutManager layout) {
        super(layout);
        this.initPanel();
    }

    public PScrollablePanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
        this.initPanel();
    }

    private void initPanel() {
        this.preferredScrollableViewportSize = null;
        this.widthTrackingPolicy = 1;
        this.heightTrackingPolicy = 1;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        if (this.preferredScrollableViewportSize == null) {
            return this.getPreferredSize();
        }
        return this.preferredScrollableViewportSize;
    }

    public Dimension getActualPreferredScrollableViewportSize() {
        return this.preferredScrollableViewportSize;
    }

    public void setPreferredScrollableViewportSize(Dimension preferredScrollableViewportSize) {
        if (!(this.preferredScrollableViewportSize == preferredScrollableViewportSize || preferredScrollableViewportSize == null && preferredScrollableViewportSize.equals(this.preferredScrollableViewportSize))) {
            Dimension oldValue = this.preferredScrollableViewportSize;
            this.preferredScrollableViewportSize = preferredScrollableViewportSize;
            this.firePropertyChange("preferredScrollableViewportSize", oldValue, preferredScrollableViewportSize);
        }
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        Component component = null;
        component = orientation == 1 ? (direction < 0 ? this.getComponentAt(visibleRect.x + visibleRect.width / 2, visibleRect.y - 1) : this.getComponentAt(visibleRect.x + visibleRect.width / 2, visibleRect.y + visibleRect.height + 1)) : (direction < 0 ? this.getComponentAt(visibleRect.x - 1, visibleRect.y + visibleRect.height / 2) : this.getComponentAt(visibleRect.x + visibleRect.width + 1, visibleRect.y + visibleRect.height / 2));
        if (component != null && component instanceof Scrollable) {
            Scrollable scrollable = (Scrollable)((Object)component);
            int x = component.getX();
            int y = component.getY();
            visibleRect.x -= x;
            visibleRect.y -= y;
            int answer = scrollable.getScrollableUnitIncrement(visibleRect, orientation, direction);
            visibleRect.x += x;
            visibleRect.y += y;
            return answer;
        }
        if (orientation == 1) {
            return visibleRect.height / 10;
        }
        return visibleRect.width / 10;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        Component component = null;
        component = orientation == 1 ? (direction < 0 ? this.getComponentAt(visibleRect.x + visibleRect.width / 2, visibleRect.y - 1) : this.getComponentAt(visibleRect.x + visibleRect.width / 2, visibleRect.y + visibleRect.height + 1)) : (direction < 0 ? this.getComponentAt(visibleRect.x - 1, visibleRect.y + visibleRect.height / 2) : this.getComponentAt(visibleRect.x + visibleRect.width + 1, visibleRect.y + visibleRect.height / 2));
        if (component != null && component instanceof Scrollable) {
            Scrollable scrollable = (Scrollable)((Object)component);
            int x = component.getX();
            int y = component.getY();
            visibleRect.x -= x;
            visibleRect.y -= y;
            int answer = scrollable.getScrollableBlockIncrement(visibleRect, orientation, direction);
            visibleRect.x += x;
            visibleRect.y += y;
            return answer;
        }
        if (orientation == 1) {
            return visibleRect.height;
        }
        return visibleRect.width;
    }

    public byte getWidthTrackingPolicy() {
        return this.widthTrackingPolicy;
    }

    public void setWidthTrackingPolicy(byte widthTrackingPolicy) {
        if (widthTrackingPolicy != 0 && widthTrackingPolicy != 1 && widthTrackingPolicy != 2) {
            throw new IllegalArgumentException();
        }
        if (this.widthTrackingPolicy != widthTrackingPolicy) {
            byte oldValue = this.widthTrackingPolicy;
            this.widthTrackingPolicy = widthTrackingPolicy;
            this.firePropertyChange("widthTrackingPolicy", oldValue, widthTrackingPolicy);
        }
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.widthTrackingPolicy == 0) {
            return false;
        }
        if (this.widthTrackingPolicy == 1) {
            if (this.getParent() instanceof JViewport) {
                return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
            }
            return false;
        }
        return true;
    }

    public byte getHeightTrackingPolicy() {
        return this.heightTrackingPolicy;
    }

    public void setHeightTrackingPolicy(byte heightTrackingPolicy) {
        if (heightTrackingPolicy != 0 && heightTrackingPolicy != 1 && heightTrackingPolicy != 2) {
            throw new IllegalArgumentException();
        }
        if (this.heightTrackingPolicy != heightTrackingPolicy) {
            byte oldValue = this.heightTrackingPolicy;
            this.heightTrackingPolicy = heightTrackingPolicy;
            this.firePropertyChange("heightTrackingPolicy", oldValue, heightTrackingPolicy);
        }
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.heightTrackingPolicy == 0) {
            return false;
        }
        if (this.heightTrackingPolicy == 1) {
            if (this.getParent() instanceof JViewport) {
                return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
            }
            return false;
        }
        return true;
    }
}

